using System.Collections;
using System.Collections.Generic;
using System.Threading.Tasks;
using UnityEngine;

public class ZOThreads : MonoBehaviour
{
	private static ZOThreads instance = null;

	// --------------------------------------------------------------------------------------------
	private static readonly Queue<System.Action> _executionQueue = new Queue<System.Action>();

	// --------------------------------------------------------------------------------------------
	void Update()
    {
		lock (_executionQueue)
		{
			while (_executionQueue.Count > 0)
			{
				_executionQueue.Dequeue().Invoke();
			}
		}
	}

	// --------------------------------------------------------------------------------------------
	static void Enqueue(IEnumerator action)
	{
		lock (_executionQueue)
		{
			_executionQueue.Enqueue(() =>
			{
				if (instance == null)
				{
					GameObject go = new();
					go.name = "ZOThreads";
					instance = go.AddComponent<ZOThreads>();
				}

				instance.StartCoroutine(action);
			});
		}
	}

	public static void ExecuteInMainThread(System.Action action)
	{
		Enqueue(ActionWrapper(action));
	}

	Task EnqueueAsync(System.Action action)
	{
		var tcs = new TaskCompletionSource<bool>();

		void WrappedAction()
		{
			try
			{
				action();
				tcs.TrySetResult(true);
			}
			catch (System.Exception ex)
			{
				tcs.TrySetException(ex);
			}
		}

		Enqueue(ActionWrapper(WrappedAction));
		return tcs.Task;
	}

	// --------------------------------------------------------------------------------------------
	static IEnumerator ActionWrapper(System.Action a)
	{
		a();
		yield return null;
	}

	// --------------------------------------------------------------------------------------------
}
